#!/usr/bin/python
import sys
import math
from pyami import mrc,imagefun,fftfun

if len(sys.argv) != 4:
	print 'Usage: python testctf.py ht pixelsize mrcfile'
	print ' ht: High Tension of the microscope in kilovolts'
	print ' pixelsize: image pixelsie in Angstroms'
	print ' mrcfile: path to a square mrc file to be analyzed'
	sys.exit(1)
ht = float(sys.argv[1])*1000
pixelsize = float(sys.argv[2])*1e-10
filepath = sys.argv[3]
# Cs value is not passed in the function right not.  WIll need to improve it.
cs = 2e-3

try:
	a = mrc.read(filepath)
except:
	print 'ERROR reading %s' % (filepath)
	sys.exit(1)
pow = imagefun.power(a)
rpixelsize = 1/pixelsize/a.shape[0]
ctfdata = fftfun.fitFirstCTFNode(pow,rpixelsize,None,ht)
if ctfdata is None:
	print 'FAILED'
else:
	print 'average defocus:  %8.3f um' % (ctfdata[0]*1e6)
	print 'astigmation:      %8.3f um' % (ctfdata[1]*1e6)
	print 'alpha:            %8.3f degrees' % (math.degrees(ctfdata[3]))
