#!/usr/bin/env python
import time
import leginon.openCVcaller
import pyami.mrc

# read the two images as numpy array
arraynew = pyami.mrc.read('./arraynew.mrc')
arrayold = pyami.mrc.read('./arrayold.mrc')

t0 = time.time()
# run libcv MatchImages
# feature minsize and maxsize are defined as in RCTAcquisition
# when the value is integer, it represents number of pixels in the feature
# when the value is a fractional float, it represents the percentage of total
# pixels in the image
minsize = 75
maxsize = 0.8
arrayold = leginon.openCVcaller.modifyImage(arrayold,1,0)
arraynew = leginon.openCVcaller.modifyImage(arraynew,1,0)
result = leginon.openCVcaller.MatchImages(arrayold, arraynew)
# timing
t1 = time.time()
print 'process time = %.1f seconds' % (t1 - t0)
