from pyscope import dmsem
import time
import threading

grabnum = 0
sumnum = 1
clear_time = 50

d = dmsem.GatanK2Super()
d.setExposureTime(8000)
d.setEarlyReturnFrameCount(grabnum,sumnum)
dc = dmsem.GatanK2Counting()
dc.setEarlyReturnFrameCount(0,10)
dc.setExposureTime(1000)
t_saved = []
t_not_saved1 = []
t_not_saved2 = []

def fastAcquire(dc):
    t1 =time.time()
    dc.setSaveRawFrames(False)
    dc.getImage()  #This calls GS_getAcquiredImage
    t2 = time.time()
    return t2 - t1

def frameSavingAcquire(d):   
    d.setSaveRawFrames(True)
    t0 =time.time()
    d.getImage()  #This calls GS_getAcquiredImage
    t1 =time.time()
    print '________________________'
    return t1 - t0

for i in range(3):
    t0 =time.time()
    t_saved.append(frameSavingAcquire(d))
    t_not_saved1.append(fastAcquire(dc))
    t_not_saved2.append(fastAcquire(dc))
    t3 = time.time()
    if clear_time > (t3-t0):
        # sleep to make sure all frames are saved to disk
        time.sleep(clear_time-(t3-t0))

print 'logger off'
print '____grab %d____sum %d________________' % (grabnum,sumnum)
print 'numGrabSum', d.getEarlyReturnFrameCount()
print '       frame saved return', map((lambda x: '%7.3f' % x),t_saved)
print 'frame 1st not save return', map((lambda x: '%7.3f' % x),t_not_saved1)
print 'frame 2nd not save return', map((lambda x: '%7.3f' % x),t_not_saved2)
print '________________________'
