#!/usr/bin/python

import sys, os
import ConfigParser
import pickle
from  appionlib.uploadSEMImages import UploadSEMImages
cfg_file = sys.argv[1]
config = ConfigParser.ConfigParser()
config.read(cfg_file)
project = config.get('sem', 'project')
z_slice = config.get('sem', 'z-slice')
description = config.get('sem', 'description')
p_file = '/root/bin/uploadedSessions.p'
uploaded_sessions = {}
if os.path.exists(p_file):
	uploaded_sessions = pickle.load(open(p_file, "rb"))

image_dir = os.path.split(cfg_file)[0]

argv = ['--image-dir='+image_dir]
argv.append('--projectid='+project)
argv.append('--z-slice='+z_slice)
argv.append('--description="'+description+'"')
if cfg_file in uploaded_sessions:
	argv.append('--session-mame='+uploaded_sessions[cfg_file])
import pdb;pdb.set_trace()

upimages = UploadSEMImages(optargs=argv)
uploaded_sessions[cfg_file] = upimages.params['sessionname']
pickle.dump(uploaded_sessions, open(p_file, "wb"))
upimages.start()
upimages.close()

