#!/usr/bin/env python

#pythonlib
import os
import sys
import glob
#appion
from appionlib import makestack2Loop

### This class is a quick fix to make make sure we can rebuild a stack to run frealign
### and maintain the order of the part6icles in the stack.
class MakestackSortedLoop(makestack2Loop.Makestack2Loop):

	### Override apParticleExtractor.py
	def callProcessParticles(self, imgdata, partdatas, shiftdata):
   		total_processed_particles = 0
   		for partdata in partdatas:
			partdatalist = [partdata]
			print str(partdatalist)
			total_processed_particles += self.processParticles(imgdata, partdatalist, shiftdata)
		return total_processed_particles
	
	### Override apParticleExtractor.py
	def getParticleFromPartData(self, stackpartdata):
		return stackpartdata
	
	### Override apParticleExtractor.py
	def setParticleData(self, partdata):
		return partdata['particle']
	
	### Override makestack2Loop.py
	def buildImgStackFileName(self, name, partnumber):
		return os.path.join(self.params['rundir'], "tmp_" + str(partnumber) + ".hed")
		

	### This class is going to process each particle seperatly and create a new stack for each particle.
	### To find the total number of processed particles, we can count the number of .hed files 
	### in the working directory.
	def findTotalProcessedParticlesInDir(self, dir):
		hedCount = len(glob.glob1(dir, "*.hed"))
		return hedCount


	### Override makestack2Loop.py
	### Override this function to ensure the indivdual stack files, each contatining
	### as single image, are not merged into the big stack until all particles have
	### been processed.
	def mergeImageStackIntoBigStack(self, imgstackfile, imgdata):
		### if the imagdata is not None, we want to skip merging at this point.
		### The small stacks will be merged after all images are processed in 
		### postLoopFunctions
		if imgdata is not None:
			dir, file = os.path.split(imgstackfile)
			bigcount = self.findTotalProcessedParticlesInDir(dir)
		else:
			### if there is no imgdata, go ahead and do the merge using the parent function
			bigcount = Makestack2Loop.mergeImageStackIntoBigStack(self, imgstackfile, imgdata)
			
		return bigcount
		

	### Override makestack2Loop.py
	### Override this function to merge all the small stacks into one big stack 
	### prior to completing the parent function
	def postLoopFunctions(self):
		### Merge all particle stacks to big stack
		totalBigStackPart = self.totalpart # or read all tmp*.hed and sort them
		for partNum in range(1, totalBigStackPart):
		  imgstackfile = os.path.join(self.params['rundir'], "tmp_" + str(partNum) + ".hed")
		  totalpart = self.mergeImageStackIntoBigStack(imgstackfile, None)
		  
		### Call the parent function
		Makestack2Loop.postLoopFunctions(self)
		

if __name__ == '__main__':
	makeStack = MakestackSortedLoop()
	makeStack.run()



