# The Leginon software is Copyright 2004
# The Scripps Research Institute, La Jolla, CA
# For terms of the license agreement
# see http://ami.scripps.edu/software/leginon-license
#

import wx
import wx.lib.filebrowsebutton as filebrowse
import threading

import leginon.gui.wx.TargetPanel
import leginon.gui.wx.ImagePanelTools
import leginon.gui.wx.Settings
import leginon.gui.wx.DnaTargetFinder
import leginon.gui.wx.ClickTargetFinder
from leginon.gui.wx.Entry import Entry, IntEntry, FloatEntry
from leginon.gui.wx.Presets import PresetChoice
from leginon.gui.wx.Choice import Choice
import leginon.gui.wx.TargetTemplate
import leginon.gui.wx.ToolBar

class Panel(leginon.gui.wx.DnaClickTargetFinder.Panel):
	def initialize(self):		
		leginon.gui.wx.DnaClickTargetFinder.Panel.initialize(self)

		self.toolbar.InsertSeparator(4)

		self.toolbar.InsertTool(5, leginon.gui.wx.ToolBar.ID_TILES,
			'tiles',shortHelpString='Tiles')
		self.toolbar.InsertTool(6, leginon.gui.wx.ToolBar.ID_MOSAIC,
			'atlasmaker',shortHelpString='Mosaic')
		self.toolbar.InsertSeparator(7)
		self.toolbar.InsertTool(8, leginon.gui.wx.ToolBar.ID_REFRESH,
			'refresh', shortHelpString='Refresh')
		self.toolbar.InsertTool(9, leginon.gui.wx.ToolBar.ID_CURRENT_POSITION,
			'currentposition', shortHelpString='Show Position')
		#self.toolbar.EnableTool(leginon.gui.wx.ToolBar.ID_SUBMIT, True)

		self.toolbar.InsertSeparator(10)
		self.toolbar.InsertTool(11, leginon.gui.wx.ToolBar.ID_FIND_SQUARES,
			'squarefinder',shortHelpString='Find DNA Forks')
		self.toolbar.EnableTool(leginon.gui.wx.ToolBar.ID_SUBMIT, True)
		
		#self.imagepanel = leginon.gui.wx.TargetPanel.TargetImagePanel(self, -1)
		
		self.Bind(leginon.gui.wx.ImagePanelTools.EVT_SETTINGS, self.onImageSettings)
		
		
	def onNodeInitialized(self):
		leginon.gui.wx.DnaClickTargetFinder.Panel.onNodeInitialized(self)
		self.toolbar.Bind(wx.EVT_TOOL, self.onFindSquaresButton,
											id=leginon.gui.wx.ToolBar.ID_FIND_SQUARES)

		self.Bind(leginon.gui.wx.ImagePanelTools.EVT_SETTINGS, self.onImageSettings)

		self.toolbar.EnableTool(leginon.gui.wx.ToolBar.ID_SETTINGS, True)


	def onSettingsTool(self, evt):
		dialog = SettingsDialog(self,show_basic=True)
		dialog.ShowModal()
		dialog.Destroy()

	def onImageSettings(self, evt):
		if evt.name == 'Original':
			dialog = OriginalSettingsDialog(self)
			if dialog.ShowModal() == wx.ID_OK:
				filename = self.node.settings['image filename']
				self.node.readImage(filename)
			dialog.Destroy()
			return
		elif evt.name == 'acquisition':
			dialog = self._FinalSettingsDialog(self)
		elif evt.name == 'focus':
			dialog = self._FinalSettingsDialog(self)

		dialog.ShowModal()
		dialog.Destroy()

	def _FinalSettingsDialog(self,parent):
		# This "private call" allows the class in the module containing
		# a subclass to redefine it in that module
		return FinalSettingsDialog(parent)

	def onFindSquaresButton(self, evt):
		#self.node.findSquares()
		threading.Thread(target=self.node.findTargets).start()
	
class OriginalSettingsDialog(leginon.gui.wx.Settings.Dialog):
	def initialize(self):
		return OriginalScrolledSettings(self,self.scrsize,False)

class OriginalScrolledSettings(leginon.gui.wx.Settings.ScrolledDialog):
	def initialize(self):
		leginon.gui.wx.Settings.ScrolledDialog.initialize(self)
		sb = wx.StaticBox(self, -1, 'Original Image')
		sbsz = wx.StaticBoxSizer(sb, wx.VERTICAL)

		self.widgets['image filename'] = filebrowse.FileBrowseButton(self, -1)
		self.widgets['image filename'].SetMinSize((500,50))
		self.dialog.bok.SetLabel('&Load')

		sz = wx.GridBagSizer(5, 5)
		sz.Add(self.widgets['image filename'], (0, 0), (1, 1),
						wx.ALIGN_CENTER_VERTICAL)

		sbsz.Add(sz, 1, wx.EXPAND|wx.ALL, 5)

		return [sbsz]

class FinalSettingsDialog(leginon.gui.wx.Settings.Dialog):
	def initialize(self):
		return FinalScrolledSettings(self,self.scrsize,False)

class FinalScrolledSettings(leginon.gui.wx.Settings.ScrolledDialog):
	def initialize(self):
		leginon.gui.wx.Settings.ScrolledDialog.initialize(self)
		#print self.__module__
		sb = wx.StaticBox(self, -1, 'Ice Analysis')
		sbszice = wx.StaticBoxSizer(sb, wx.VERTICAL)
		sb = wx.StaticBox(self, -1, 'Focus Targets')
		sbszft = wx.StaticBoxSizer(sb, wx.VERTICAL)
		sb = wx.StaticBox(self, -1, 'Acquisition Targets')
		sbszat = wx.StaticBoxSizer(sb, wx.VERTICAL)

		self.widgets['ice box size'] = FloatEntry(self, -1, chars=8)
		self.widgets['ice thickness'] = FloatEntry(self, -1, chars=8)
		self.widgets['ice min mean'] = FloatEntry(self, -1, chars=8)
		self.widgets['ice max mean'] = FloatEntry(self, -1, chars=8)
		self.widgets['ice max std'] = FloatEntry(self, -1, chars=8, min=0.0)
		self.widgets['ice min std'] = FloatEntry(self, -1, chars=8, min=0.0)
		self.widgets['acquisition convolve'] = wx.CheckBox(self, -1, 'Convolve')
		self.widgets['acquisition convolve template'] = \
			leginon.gui.wx.TargetTemplate.Panel(self, 'Convolve Template')
		self.widgets['acquisition constant template'] = \
			leginon.gui.wx.TargetTemplate.Panel(self, 'Constant Template', targetname='Constant target')

		szice = wx.GridBagSizer(5, 5)
		label = wx.StaticText(self, -1, 'Box size:')
		szice.Add(label, (0, 0), (1, 1), wx.ALIGN_CENTER_VERTICAL)
		szice.Add(self.widgets['ice box size'], (0, 1), (1, 1),
			wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE|wx.ALIGN_RIGHT)
		label = wx.StaticText(self, -1, 'Reference Intensity:')
		szice.Add(label, (1, 0), (1, 1), wx.ALIGN_CENTER_VERTICAL)
		szice.Add(self.widgets['ice thickness'], (1, 1), (1, 1),
			wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE|wx.ALIGN_RIGHT)
		label = wx.StaticText(self, -1, 'Min. mean:')
		szice.Add(label, (2, 0), (1, 1), wx.ALIGN_CENTER_VERTICAL)
		szice.Add(self.widgets['ice min mean'], (2, 1), (1, 1),
			wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE|wx.ALIGN_RIGHT)
		label = wx.StaticText(self, -1, 'Max. mean:')
		szice.Add(label, (3, 0), (1, 1), wx.ALIGN_CENTER_VERTICAL)
		szice.Add(self.widgets['ice max mean'], (3, 1), (1, 1),
			wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE|wx.ALIGN_RIGHT)
		label = wx.StaticText(self, -1, 'Max. stdev.:')
		szice.Add(label, (4, 0), (1, 1), wx.ALIGN_CENTER_VERTICAL)
		szice.Add(self.widgets['ice max std'], (4, 1), (1, 1),
			wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE|wx.ALIGN_RIGHT)
		label = wx.StaticText(self, -1, 'Min. stdev.:')
		szice.Add(label, (5, 0), (1, 1), wx.ALIGN_CENTER_VERTICAL)
		szice.Add(self.widgets['ice min std'], (5, 1), (1, 1),
			wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE|wx.ALIGN_RIGHT)
		szice.AddGrowableCol(1)

		sbszice.Add(szice, 1, wx.EXPAND|wx.ALL, 5)

		szft = self.FocusFilterSettingsPanel()
		sbszft.Add(szft, 1, wx.EXPAND|wx.ALL, 5)

		szat = wx.GridBagSizer(5, 5)
		szat.Add(self.widgets['acquisition convolve'], (0, 0), (1, 2),
			wx.ALIGN_CENTER_VERTICAL)
		szat.Add(self.widgets['acquisition convolve template'], (1, 0), (1, 1),
			wx.ALIGN_CENTER|wx.FIXED_MINSIZE)
		szat.Add(self.widgets['acquisition constant template'], (2, 0), (1, 1),
			wx.ALIGN_CENTER|wx.FIXED_MINSIZE)
		szat.AddGrowableCol(0)

		sbszat.Add(szat, 1, wx.EXPAND|wx.ALL, 5)

		self.bice = wx.Button(self, -1, 'Test')
		self.cice = wx.Button(self, -1, '&Clear targets')
		szbutton = wx.GridBagSizer(5, 5)
		szbutton.Add(self.cice, (0, 0), (1, 1), wx.ALIGN_CENTER_VERTICAL|wx.ALIGN_LEFT)
		szbutton.Add(self.bice, (0, 1), (1, 1),
			wx.ALIGN_CENTER_VERTICAL|wx.ALIGN_RIGHT)
		szbutton.AddGrowableCol(1)

		szt = wx.GridBagSizer(5, 5)
		szt.Add(sbszft, (0, 0), (1, 1), wx.EXPAND|wx.ALL)
		szt.Add(sbszat, (0, 1), (1, 1), wx.EXPAND|wx.ALL)


		#self.Bind(wx.EVT_BUTTON, self.onAnalyzeIceButton, self.bice)
		self.Bind(wx.EVT_BUTTON, self.onClearButton, self.cice)

		return [sbszice, szt, szbutton]

	
	def FocusFilterSettingsPanel(self):
		self.widgets['focus convolve'] = wx.CheckBox(self, -1, 'Convolve')
		self.widgets['focus convolve template'] = \
			leginon.gui.wx.TargetTemplate.Panel(self, 'Convolve Template')
		self.widgets['focus constant template'] = \
			leginon.gui.wx.TargetTemplate.Panel(self, 'Constant Template', targetname='Constant target')
		self.widgets['focus one'] = wx.CheckBox(self, -1, 'Threshold to one focus target')
		szft = wx.GridBagSizer(5, 5)
		szft.Add(self.widgets['focus convolve'], (0, 0), (1, 2),
			wx.ALIGN_CENTER_VERTICAL)
		szft.Add(self.widgets['focus convolve template'], (1, 0), (1, 1),
			wx.ALIGN_CENTER|wx.FIXED_MINSIZE)
		szft.Add(self.widgets['focus constant template'], (2, 0), (1, 1),
			wx.ALIGN_CENTER|wx.FIXED_MINSIZE)
		szft.Add(self.widgets['focus one'], (3, 0), (1, 1),
			wx.ALIGN_CENTER_VERTICAL)
		szft.AddGrowableCol(0)

		return szft

	def onClearButton(self, evt):
		self.dialog.setNodeSettings()
		self.node.clearTargets('acquisition')
		self.node.clearTargets('focus')

class SettingsDialog(leginon.gui.wx.DnaTargetFinder.SettingsDialog):
	def initialize(self):
		return ScrolledSettings(self,self.scrsize,False,self.show_basic)

class ScrolledSettings(leginon.gui.wx.DnaTargetFinder.ScrolledSettings):
	def initialize(self):
		tfsd = leginon.gui.wx.DnaTargetFinder.ScrolledSettings.initialize(self)
		if self.show_basic:
			return tfsd
		else:
			sb = wx.StaticBox(self, -1, 'Raster Finder Settings')
			sbsz = wx.StaticBoxSizer(sb, wx.VERTICAL)

			self.widgets['skip'] = wx.CheckBox(self, -1, 'Skip automated raster target making')
			self.widgets['focus interval'] = IntEntry(self, -1, chars=6)
			sz = wx.GridBagSizer(5, 5)
			sz.Add(self.widgets['skip'], (0, 0), (1, 1),
							wx.ALIGN_CENTER_VERTICAL)

			label = wx.StaticText(self, -1, 'Focus every')
			sz.Add(label, (1, 0), (1, 1), wx.ALIGN_CENTER_VERTICAL)
			sz.Add(self.widgets['focus interval'], (1, 1), (1, 1),
										wx.ALIGN_CENTER_VERTICAL|wx.FIXED_MINSIZE|wx.ALIGN_RIGHT)
			label = wx.StaticText(self, -1, 'image')
			sz.Add(label, (1, 2), (1, 1), wx.ALIGN_CENTER_VERTICAL)

			sbsz.Add(sz, 0, wx.ALIGN_CENTER|wx.ALL, 5)

			return tfsd + [sbsz]


if __name__ == '__main__':
	class App(wx.App):
		def OnInit(self):
			frame = wx.Frame(None, -1, 'Raster Finder Test')
			panel = Panel(frame)
			frame.Fit()
			self.SetTopWindow(frame)
			frame.Show()
			return True

	app = App(0)
	app.MainLoop()

