#!/usr/bin/env python

#
# COPYRIGHT:
#       The Leginon software is Copyright 2003
#       The Scripps Research Institute, La Jolla, CA
#       For terms of the license agreement
#       see  http://ami.scripps.edu/software/leginon-license
#

from leginon import leginondata
import dnatargetfinder
import threading
import ice
import numpy
import math
import pyami.quietscipy
from scipy import ndimage
from pyami import arraystats, numpil
import gui.wx.DnaFinder
import polygon
import itertools
import dnaForkTargetFinderPipeline

class DnaFinder(dnatargetfinder.DnaTargetFinder):
	panelclass = gui.wx.DnaFinder.Panel
	settingsclass = leginondata.RasterFinderSettingsData
	defaultsettings = dict(dnatargetfinder.DnaTargetFinder.defaultsettings)
	defaultsettings.update({
		'skip': False,
		'publish polygon': False,
		'image filename': '',
		'focus convolve': False,
		'focus convolve template': [],
		'focus constant template': [],
		'focus one': False,
		'acquisition convolve': False,
		'acquisition convolve template': [],
		'acquisition constant template': [],
		'focus interval': 1,
	})
	def __init__(self, id, session, managerlocation, **kwargs):
		dnatargetfinder.DnaTargetFinder.__init__(self, id, session, managerlocation, **kwargs)
		self.rasterpoints = None
		self.polygonrasterpoints = None
		self.doneevents = {}
		self.displayedtargetdata = {}
		self.targetlist = []
		self.userpause = threading.Event()
		self.images = {
			'Original': None,
		}
		self.image_path = session['image path']  # Save image path for later processing
		self.imagetargets = {
			'Original': {},
			'Final': {},
		}

		self.foc_counter = itertools.count()
		self.foc_activated = False

		self.start()

	def applyTargetTemplate(self, centers, type):
		if type == 'focus':
			if not self.foc_activated:
				return []
			vects = self.settings['focus convolve template']
		elif type == 'acquisition':
			vects = self.settings['acquisition convolve template']
		newtargets = []
		for center in centers:
			for vect in vects:
				target = center[0]+vect[0], center[1]+vect[1]
				newtargets.append(target)
		return newtargets

	def getTargetDataList(self, typename):
		displayedtargetdata = {}
		targetsfromimage = self.panel.getTargetPositions(typename)
		for t in targetsfromimage:
			c,r = t
			targetdata = self.mosaicToTarget(typename, r, c)
			if t not in displayedtargetdata:
				displayedtargetdata[t] = []
			displayedtargetdata[t].append(targetdata)
		self.displayedtargetdata = displayedtargetdata
	
	
	def submitTargets(self):
		self.userpause.set()
		'''
		try:
			if self.settings['autofinder']:
				return
		except:
			pass

		if self.targetlist is None:
			self.targetlist = self.newTargetList()
			self.publish(self.targetlist, database=True, dbforce=True)

		self.logger.info('Submitting targets...')
		self.getTargetDataList('acquisition')
		self.getTargetDataList('focus')
		self.getTargetDataList('preview')
		try:
			self.publish(self.targetlist, pubevent=True)
		except node.PublishError, e:
			self.logger.error('Submitting acquisition targets failed')
		else:
			self.logger.info('Acquisition targets submitted')

		reference_target = self.getDisplayedReferenceTarget()
		if reference_target is not None:
			try:
				self.publish(reference_target, database=True, pubevent=True)
			except node.PublishError, e:
				self.logger.error('Submitting reference target failed')
			else:
				self.logger.info('Reference target submitted')
		'''


	def findTargets(self):
		self.setStatus('processing')
		message = 'finding targets'
		self.logger.info(message)
		imagepath = self.image_path + "/"
		self.logger.info('Processing the square ' + self.imageStartString + ' at location ' + imagepath)
		# Calls the external python script doing all the processing on the image
		dnaForkTargetFinderPipeline.processImage(imagepath,self.imageStartString)
		
		
		# Read in the mosaic image created by the processing script
		filename = imagepath + self.imageStartString[:-1] + 'WholeSquare.tif'
		mosaic_image = numpil.read(filename)
		
		# Try to add the image to database => is not really working
		imagedata = leginondata.AcquisitionImageData()
		imagedata['session'] = self.session
		imagedata['image'] = mosaic_image
		imagedata['filename'] = filename		
		imagedata.insert(force=True)
		self.publish(imagedata, dbforce= True, pubevent=True)
		
		self.currentimagedata = imagedata
		
		# Display current image	from database
		self.readImage(filename)		
		
		# Read in Target coordinates from textfile
		file_path = filename[:-3] + 'txt'

		target_file = open(file_path,'r')

		goodpoints = []
		target_list = target_file.readlines()
		for target in target_list:
		    coordinates = target.rstrip().split(',')
		    x = float(coordinates[0])
		    y = float(coordinates[1])
		    goodpoints.append((x,y))
		
		self.setTargets(goodpoints, 'acquisition', block=True)
		
		#self.targetlist = goodpoints
		#self.publishTargets(imagedata, 'acquisition', self.targetlist)
		#self.panel.submitTargets()
		#targetlist = leginondata.ImageTargetListData()
		#self.publishTargets(imagedata, 'acquisition', targetlist)		
		
		self.setStatus('waiting')
		#self.setStatus('idle')
		


		