#!/usr/bin/env python
import sys
from appionlib import apDDprocess, apDatabase
from pyami import mrc

if __name__ == '__main__':
	dd = apDDprocess.DirectDetectorProcessing()
	if len(sys.argv) != 2:
		print 'Usage: correctframes.py image'
		print '  image (str or int): imagefilename or imageid'
		sys.exit()
	imagevalue = sys.argv[1]
	try:
		imageid = int(imagevalue)
		# imagevalue is database imageid (an integer)
		imagedata = apDatabase.getImageDataFromSpecificImageId(imageid)
	except ValueError:
		# imagevalue is filename
		imgtree = apDatabase.getSpecificImagesFromDB([imagevalue])
		imagedata = imgtree[0]
		imageid = imagedata.dbid
	# choose the subclass to initiate using the session name
	dd = apDDprocess.initializeDDFrameprocess(imagedata['session']['name'],False)
	dd.setImageData(imageid)

	stackpath = dd.makeCorrectedRawFrameStack('.')
	print stackpath
