#!/usr/bin/env python
import sys
from pyami import mrc

if __name__ == '__main__':
	if len(sys.argv) < 4:
		print 'Usage: simple_correctstack.py inputstack outputstack normimage (darkimage)'
		print '  all options are file paths'
		sys.exit()
	inpath = sys.argv[1]
	outpath = sys.argv[2]
	normpath = sys.argv[3]
	# dark is optional
	if len(sys.argv) == 5:
		has_dark = True
		darkpath = sys.argv[4]
		dark = mrc.read(darkpath)
	else:
		has_dark = False

	# stack height
	header = mrc.readHeaderFromFile(inpath)
	nx = header['nx']
	ny = header['ny']
	nz = header['nz']

	#shape check
	norm = mrc.read(normpath,0)
	normshape = norm.shape
	if normshape[1] != nx or normshape[0] != ny:
		print 'Shape mismatch.  raw stack (x,y) at (%d,%d) norm at (%d,%d)' % (nx,ny,normshape[2],normshape[1])
		sys.exit(1)

	half_way = int(nz // 2)
	for i in range(nz):
		print 'processing frame %d' % i
		a = mrc.read(inpath,i)
		if has_dark:
			a -= dark
		a *= norm
		if i == 0:
			mrc.write(a,outpath)
		elif i == half_way:
			# make header stats according to mid point frame
			mrc.append(a,outpath,True)
		else:
			mrc.append(a,outpath,False)
	print "------------"
	print "output saved as %s" % (outpath)
