#!/usr/bin/env python
import sys
from appionlib import apDDprocess, apDatabase
from pyami import mrc, imagefun

if __name__ == '__main__':
	dd = apDDprocess.DirectDetectorProcessing()
	if len(sys.argv) != 4:
		print 'Usage: correctframes.py start_frame nframe image'
		print '  start_frame (int): first frame to use (minimal=0)'
		print '  nframe (int): number of frames to sum up'
		print '  image (str or int): imagefilename or imageid'
		sys.exit()
	start_frame = int(sys.argv[1])
	nframe = int(sys.argv[2])
	imagevalue = sys.argv[3]
	try:
		imageid = int(imagevalue)
		dd.setImageId(imageid)
	except ValueError:
		imgtree = apDatabase.getSpecificImagesFromDB([imagevalue])
		dd.setImageData(imgtree[0])
	corrected = dd.correctFrameImage(start_frame,nframe,False)
	#outfile = 'corrected_frame%d_%d.mrc' % (start_frame,nframe)
	outfile = 'corrected_frame%d.mrc' % (start_frame)
	powfile = 'power.mrc'
	mrc.write(corrected,outfile)
	print ' '
	print 'Saved as %s' % (outfile)
