#!/usr/bin/env python
#Script to auto update appion and its rpm on the cluster

import sys, os, shutil

specFile = '/root/rpmbuild/SPECS/myami-2.2.spec'
workingDir = '/root/src/myami-2.2'
sourcesDir = '/root/rpmbuild/SOURCES'
version   = '2.2'

def exception_handler (message):
   sys.stderr.write(message)
   sys.exit(1)

def update_spec (file2Update):
   rval = 0
   tempFile = "/tmp/upda_tmp." + str(os.getpid())

   try:
      input = open(file2Update)
   except IOError, why:
      exception_handler("Couldn't open spec file: " + str(why))
      
   try:
      output = open(tempFile, 'w')
   except IOError, why:
      exception_handler("Couldn't open temp file: " + str(why))

   Found = 0

   #The next block of code updates the release # in the Spec file
   for l in input:
      if not Found:
         lineAsList = l.split(':')
         if (lineAsList[0] == 'Release'):
            rval = int(lineAsList[1])
	    rval += 1
	    l = 'Release:\t' + str(rval) +'\n'
	    Found = 1

      try:
         output.write(l)
      except IOError, why:
         exception_handler("Couldn't write to temp file: " + str(why))
       

   input.close()
   output.close()

   if (Found == 0):
       exception_handler("Could determine the previouse revision: 'Release:' not found")

   #Replace the old spec file with the update one
   shutil.move(tempFile, file2Update)
   
   return rval


def update_src (wcDir, ver, rpmSrcDir):
   #Update the appion source via svn
   try:
      os.chdir(wcDir)
   except OSError, why:
      exception_handler("Could change to working copy directory: " +
                 str(why))
   os.system('/usr/bin/svn update')

   os.chdir('../')
   cmdstring = '/bin/tar czf ' + rpmSrcDir + '/myami-' + ver + '.tar.gz ' + os.path.basename(wcDir)
   os.system (cmdstring)


def  createRepo (spec):

   #Build the new  rpm
   print 'Running /usr/bin/rpmbuild --clean -bb ' + spec
   os.system('/usr/bin/rpmbuild --clean -bb ' + spec)



update_src(workingDir, version, sourcesDir)
releaseNum = update_spec(specFile)
packageFileName = 'myami-' + version + '-' + str(releaseNum) + '.x86_64.rpm'
#print specFile, packageFileName, repoDir
createRepo (specFile)
os.system('rpm -Uvh /root/rpmbuild/RPMS/x86_64/' + packageFileName)


